#!/usr/bin/env Rscript 
# tato pragma je nutna pro spusteni z prikazove radky Bash

# source('slunecni_hodiny.R') 		# z prostredi R
# commandArgs<- function (){ c(50,20) }; source("slunecni_hodiny.R") 
	# tak to se spousti skript se vstupnimi parametry, tzn. deklinace a uklon_jizni_steny

# pokud je na prvni radku citovana pragma a je nastaven execution flag ve vlastnostech souboru (chmod +x slunecni_hodiny.R), tak se tento script da spustit z prikazove radky podobne jako skript bash.sh, ale neni to moc nastavene, hlavne zlobi diakritika v PDF
# z prikazove radky: R < scriptName.R --no-save  

# vsechny uhly se pocitaji v radianech, ale vystupni i vstupni hodnoty jsou ve stupnich

# Toto vygeneruje vsechny prikazove radky:
# cat(paste("\ncommandArgs<- function (){ c(",5*(6:14),",20) }; source(\"slunecni_hodiny.R\")", sep=""), sep="")
# cat(paste("\ncommandArgs<- function (){ c(50,",5*(-14:14),") }; source(\"slunecni_hodiny.R\")", sep=""), sep="")

setwd('/home/jerom/dum/drazicka/slunecni_hodiny/R/') # misto, kam se ukladaji vystupy - obrazky, txt
options(digits=3) # pri vystupu zaokrouhli pocet cislic na tri - cat(1.2345676) ... 1.23
graphics.off() # vypne vsechna stara okna s ciferniky a jinymi grafy

# definice pouzivanych funkci --------------------------------------------------
format_vektoru <- function(vektor) {
	return(paste("[",paste(round(vektor,3), collapse="; "), "]", sep=""))
}

rotace_matice_po_radcich<- function(matice,orientace=1, pocet_radku=1) {
# 	pocet_radku neni dodelany - for ....
# orientace 0 dolu; 1 nahoru
	if (orientace == 1) {
		matice <- rbind(matice[2:(nrow(matice)),],matice[1,])
	} else {
		matice <- rbind(matice[nrow(matice),],matice[1:(nrow(matice)-1),])
	}
}

skalarni_soucin <- function(a,b) {
	return (sum(a*b)) # z nejakeho zahadneho duvodu R oznacuje za skalarni soucin cross product
}

# Velikost vektoru 2D i 3D
velikost <- function(a) {
	return (sum(a^2)^.5)
}

uhel_vektoru_vs <- function(a,b) {
	# uhel vektoru v radianech pocitany z vektoroveho soucinu
	# |w⃗ |=|u⃗ |⋅|v⃗ |⋅sin(α) # toto je vektorovy soucin
	return(asin(velikost(vektorovysoucin(a,b)/velikost(a)/velikost(b))))
}

uhel_vektoru <- function(a,b) {
	# skalarni_soucin=a.b.cos
	if (velikost(a)>0 && velikost(b)>0) {
		return(acos(round(skalarni_soucin(a,b)/velikost(a)/velikost(b),12)))
			# zaokrouhleni je, aby to vracelo nulovou hodnotu u cisel typu 1,23e-17
	} else {
		return(0)
	}
}

print_uhel_vektoru <- function(a,b, text="", odsazeni="") {
	# pomocna funkce pro vypisy
	cat(c(odsazeni, "Vektory ", text,", tzn. ", format_vektoru(a)," a ",format_vektoru(b), ", sviraji uhel: ", round(rad2deg(uhel_vektoru(a, b)),3), "°"), sep="")
}

vektorovy_soucin <- function(a,b){
	# pouze 3D
	# pozor poničí názvy sloupců/řádek, je třeba je opravit ručně.
	i = a[2] * b[3] - b[2] * a[3];
	j = b[1] * a[3] - a[1] * b[3];
	k = a[1] * b[2] - b[1] * a[2];
	return (c(i, j, k))
}

rotace_vektoru_okolo_jineho_vektoru <- function(vektor, osa, uhel) {
	# bude-li treba, dodelat podle tohoto vzorecku:
	# https://en.wikipedia.org/wiki/Rodrigues%27_rotation_formula
}

rotace_vektoru_okolo_osy <- function( vektor, osa, uhel) { 
	# "vektor" je triprvkovy vektor ala c(1,2,3), osa ("x","y","z"), uhel [radiany] 
	if ( length(vektor) != 3) {
		print (c("Vektor", vektor, "je spatny"))
	} else {
		# toto jsou rotacni matice
		rx <- rbind(c(1,0,0), c(0, cos(uhel), -sin(uhel)), c(0, sin(uhel), cos(uhel)))
		ry <- rbind( c(cos(uhel), 0,  sin(uhel)), c(0,1,0), c(-sin(uhel),0,  cos(uhel)))
		rz <- rbind( c(cos(uhel),  -sin(uhel), 0), c(sin(uhel),  cos(uhel),0), c(0,0,1))
	
		if (osa == "x") { return (as.vector(rx %*% vektor)) } 
			# toto %*% je oznaceni/operator pro cross product
		if (osa == "y") { return (as.vector(ry %*% vektor)) }
		if (osa == "z") { return (as.vector(rz %*% vektor)) }
	}
}

rad2deg <- function(uhel) {
	# d=r⋅180∕π
	return(uhel*180/pi) 
}	

deg2rad <- function(uhel) {
	# r=d⋅π∕180
	return(pi*uhel/180) 
}	

# --- Nastaveni vstupnich parametru --------------------------------------------

if ( length(commandArgs()) == 2 ) {
	# nacte argumenty z prikazove radky, ktere maji prednost
	# commandArgs<- function (){ c(50,20) }; source("slunecni_hodiny.R") 
		# tak to se nastavuji a spousti vstupni parametry na prikazove radce v ramci R
	# rm(commandArgs); source("slunecni_hodiny.R") 
		# tak to vynuluji vstupni parametry v ramci R
	# https://www.r-bloggers.com/passing-arguments-to-an-r-script-from-command-lines/
	deklinace<-deg2rad(commandArgs()[1])
	uklon_jizni_steny<-deg2rad(commandArgs()[2])
	cat("\nParametry vztaty z příkazové řádky.")
} else { 
	# Nastaveni defaultnich hodnot: Dražická: 50.0732750N, 14.6521542E
	deklinace <- deg2rad(70) 		# debug
	uklon_jizni_steny=deg2rad(20) 	# debug - k zapadu [stupne]
	uklon_jizni_steny=deg2rad(-20) 	# debug - k zapadu [stupne]

	deklinace <- deg2rad(50.0732750) # vychozi deklinace zadana ve stupnich
	uklon_jizni_steny=deg2rad(28.83) # k zapadu>0; k východu<0 [stupne]
	cat("\nZa parametry vzaty výchozí hodnoty.")
}

cat("\n\n--- Vstupní proměnné ---")
cat (c( "\nDeklinace domu (Prahy): ", rad2deg(deklinace),"°" ), sep="")
cat (c( "\nJižní stěna domu je ukloněna k západu o: ", rad2deg(uklon_jizni_steny),  "°"  ), sep="")
# cat (c( "\nVzdálenost stojky stylu: ", vzdalenost_stojky,  " cm\n"  ), sep="")

cat("\n  Ciferník je počítán pro dny rovnodennosti, kdy Slunce se pohybuje po rovníku. Odchylka v jiné dny činní cca 15 minut, \"akademickou čtvrthodinku\".\n")
polarka <- c(0,0,1)
	cat (c( "\nPolárka, osa z: ", format_vektoru(polarka), ", velikost: ",  velikost(polarka) ),sep="")
vychod  <- c(0,1,0)
	cat (c( "\nVýchod, osa y: ", format_vektoru(vychod), ", velikost: ",  velikost(vychod)), sep="")
jih  <- c(1,0,0)
	cat (c( "\nJih, osa x, poledne ke Slunci: ", format_vektoru(jih), ", velikost: ",  velikost(jih), sep=""))

stylus_nahoru <- polarka
stylus_dolu <- -polarka
cat("\nStylus nahoru, resp. dolu je v podstate vektor: +polarka u vodorovnych hodin, resp. -polarka u svislych hodin.")
cat("\n  Souřadnice stylu či přesněji polu (polos) jsou zároveň, souřadnicemi koncového bodu, který trčí ve vzduchu.")
cat("\n  Na okraj: Polarka je normálový vektor rovníku. Stylus je obecně ukazatel. Polus je ten ukazatel, který je rovnoběžný s osou Zeměkoule. Udává se, že Gnomon je ukazatel kolmý na ciferník (obávám se, že správně kolmý na zemi. Protože u rovníkových hodin je vždy ukazatel kolmý na ciferník, i když tím ukazatelem je polus.)\n")
	
zenit <- rotace_vektoru_okolo_osy(polarka, "y", (pi/2-deklinace))
cat (c( "Zenit (normálový vektor základové desky baráku): ", format_vektoru(zenit), ", velikost: ",  velikost(zenit), "\n  Rotace polarky okolo osy y o úhel (90°-deklinace)\n"  ), sep="")

print_uhel_vektoru(stylus_dolu, zenit, "stylus_dolu, zenit", "  Kontrola: ") # kontrola 

cat ("\n\n--- Vypocet orientace baraku ---" )

# 1. verze vypoctu, ta co je v dokumentu
# dum na polu pootocime o uklon naseho domu 
ukloneny_normalovy_vektor_domu_na_polu<-rotace_vektoru_okolo_osy(jih, "z",uklon_jizni_steny) 
# Podruhé ho natočíme o 40° ke slunci:
ukloneny_normalovy_vektor_naseho_domu<-rotace_vektoru_okolo_osy(ukloneny_normalovy_vektor_domu_na_polu, "y",pi/2-deklinace)

# print(jih)
# print(uklon_jizni_steny)
# print(rad2deg(uklon_jizni_steny))
# cat ("\n\n--- jsem tady ---" )

#2. verze vypoctu
# normalovy_vektor_jizni_steny 
vektor_jizni_hrany_na_polu <- rotace_vektoru_okolo_osy(vychod, "z", uklon_jizni_steny)
cat (c( "\nNa severnim polu by jizni hrana byl vektor: [", signif(vektor_jizni_hrany_na_polu,digits=4) , "], velikost:",  velikost(vektor_jizni_hrany_na_polu)), sep=" ")
cat("\n  Rotace východu o úklon jižní stěny kolem osy z, polárky.")

vektor_jizni_hrany <- rotace_vektoru_okolo_osy(vektor_jizni_hrany_na_polu, "y", (pi/2-deklinace))
cat (c( "\nU nas ma jizni hrana vektor: ", format_vektoru(vektor_jizni_hrany) , ", velikost: ",  velikost(vektor_jizni_hrany)), sep="")
cat("\n  Rotace jižní hrany o kolem osy y, východu o (90° - deklinace). \"Přesun do Prahy.\"")
print_uhel_vektoru(vektor_jizni_hrany, vychod, "vektor_jizni_hrany, vychod", "\n  Kontrola: ")

normalovy_vektor_jizni_steny <- vektorovy_soucin(vektor_jizni_hrany, zenit)
normalovy_vektor_jizni_steny <- normalovy_vektor_jizni_steny/velikost(normalovy_vektor_jizni_steny)
cat (c( "\n\nJizni stena ma normalovy vektor: ", format_vektoru(normalovy_vektor_jizni_steny) , ", velikost: ",  velikost(normalovy_vektor_jizni_steny)), sep="")
cat("\n  Vektorový součin jižní hrany baráku a zenitu vytváří normálový vektor jižní stěny (hřebík, který je zatlučen kolmo do stěny, či stojka kolmá ke stěně, která podpírá stylus). Velikost normalizována na 1.")

print_uhel_vektoru(ukloneny_normalovy_vektor_naseho_domu, normalovy_vektor_jizni_steny, "ukloneny_normalovy_vektor_naseho_domu, normalovy_vektor_jizni_steny", "\n  Kontrola 1. a  2. verze výpočtu: ")
cat("\n  Vidíme, že oběma postupy dospíváme ke stejnému výsledku.")

cat ("\n\n--- Vypocet orientace stylu vůči stěně ---" )
normalovy_vektor_plochy_prumetu <- vektorovy_soucin(polarka, normalovy_vektor_jizni_steny)
normalovy_vektor_plochy_prumetu <- normalovy_vektor_plochy_prumetu /velikost(normalovy_vektor_plochy_prumetu )
cat (c( "\nNormálový vektor plochy kolmého prům;ětu stylu na jižní stěnu: ", format_vektoru(normalovy_vektor_plochy_prumetu) , ", velikost: ",  velikost(normalovy_vektor_plochy_prumetu)), sep="")
cat("\n  Vektorový součin normálového vektoru jižní stěny baráku a vektoru stylu vytváří normálový vektor plochy kolmého průmětu stylu na barák. V této rovině leží stojka, která podpírá stylus ode zdi. ")

vektor_kolmeho_prumetu_na_jizni_stene <- vektorovy_soucin(normalovy_vektor_plochy_prumetu, normalovy_vektor_jizni_steny)
vektor_kolmeho_prumetu_na_jizni_stene <- vektor_kolmeho_prumetu_na_jizni_stene/velikost(vektor_kolmeho_prumetu_na_jizni_stene)
cat ("\n\nKolmý průmět stylu na jižní stěnu má vektor: ", format_vektoru(vektor_kolmeho_prumetu_na_jizni_stene), ", velikost: ",  velikost(vektor_kolmeho_prumetu_na_jizni_stene ), sep="")
cat("\n  Potřebujeme spočítat čáru na stěně, kolmo pod stylem, která bývá ukloněná od svislice. Tu získáme jako vektorový součin normálových vektorů jižní stěny baráku a plochy průmětu stylu na jižní stěně baráku. Opět normován na jednotkovou velikost.")

uklon_prumetu_stylu_od_zenitu<- uhel_vektoru(zenit, -vektor_kolmeho_prumetu_na_jizni_stene)
print_uhel_vektoru(zenit, -vektor_kolmeho_prumetu_na_jizni_stene, "zenit, vektor_kolmeho_prumetu_na_jizni_stene", "\n")
cat("\n  Toto je tedy úhel od svislice baráku (zenit) a o kolik je vychýlen do strany průmět stylu na stěně.")
cat("\n  Pokud je dům natočen k západu (úklon jižní stěny >0), resp. k východu (úklon jižní stěny <0), bude dolní bod stylu vychýlen o tento vypočítaný úhel doprava, resp. doleva.")
cat("\n\n-----------------------------------------------------------------------")  
cat("\n  U tohoto domu je úklon jižní stěny: ", rad2deg(uklon_jizni_steny), "°, tedy stylus bude dole ukloněn od svislice o ", rad2deg(uklon_prumetu_stylu_od_zenitu),"° ", sep="")
if (uklon_jizni_steny>0) {cat ("doprava. ")} else {cat("doleva. ")}
cat("\n-----------------------------------------------------------------------")  
cat("\nToto je základní údaj pro stavbu slunečních hodin.")

cat("\n\nDále ještě potřebujeme znát úhel, o který se stylus odklání od jižní stěny domu. Ne od svislice, tam je to vždy rovno (90°-deklinace) V ČR je tento úhel podle úklonu stěny něco okolo 40°.")
uhel_stylus_stena <- uhel_vektoru(stylus_dolu, vektor_kolmeho_prumetu_na_jizni_stene)
print_uhel_vektoru(stylus_dolu, vektor_kolmeho_prumetu_na_jizni_stene, "stylus, vektor_kolmeho_prumetu_na_jizni_stene", "\n\n")

cat("\n-----------------------------------------------------------------------")  
cat("\n  Úhel, který svírá stylus kolmo se stěnou baráku je: ",rad2deg(uhel_stylus_stena), "°. ", sep="")
cat("\n-----------------------------------------------------------------------")  
cat("\nToto je druhý základní údaj pro stavbu slunečních hodin.")

cat ("\n\n--- Relativní souřadnice stylu ---" )
cat("\nPředpokládáme, že začátek stylu ve stěně má relativní souřadnice [0; 0] (dolu je x, doprava je y, ode zdi z) a předpokládáme jednotkovou délku stylu, tzn. 1 m. Když chcete stylus kratší či delší, musíte si výsledné hodnoty vynásobit délkou vašeho stylu.")

cat("\n Delka stylu je: ", velikost(stylus_dolu), " m. ", sep="")
zkracena_delka_kolmeho_prumetu_na_jizni_stene <- skalarni_soucin(stylus_dolu, vektor_kolmeho_prumetu_na_jizni_stene) # toto je skalar, číslo.
cat("\n Zkrácená délka kolmého průmětu stylu na stěnu je: ", zkracena_delka_kolmeho_prumetu_na_jizni_stene , " m. ")
zkraceny_vektor_kolmeho_prumetu_na_jizni_stene <- vektor_kolmeho_prumetu_na_jizni_stene*zkracena_delka_kolmeho_prumetu_na_jizni_stene # toto je 3D vektor 
# stop()

uchylka_na_stene_x <- skalarni_soucin(zkraceny_vektor_kolmeho_prumetu_na_jizni_stene, vektor_jizni_hrany)
uchylka_na_stene_y <- skalarni_soucin(zkraceny_vektor_kolmeho_prumetu_na_jizni_stene, zenit)
uchylka_od_steny_z <- skalarni_soucin(normalovy_vektor_jizni_steny, stylus_dolu)

cat("\n\n-----------------------------------------------------------------------")  
cat (c( "\nKonec stylu o délce ",velikost(stylus_dolu)," m je uchýlen stojkou do relativních souřadnic od počátku stylu: [", round(uchylka_na_stene_x, 3) , "; " , round(uchylka_na_stene_y, 3), "; " , round(uchylka_od_steny_z, 3), "] metru\n"), sep="")
cat("\n-----------------------------------------------------------------------")  
cat("\nToto jsou základní údaje pro stavbu slunečních hodin. Tyto hodnoty vynásobíte délkou Vašeho stylu a dostanete souřadnice, kde je je třeba upevnit stylus a kde je třeba vyvrtat kolmá díra do stěny [x,y] pro stojku stylu [z souřadnice je výška stojky].")

cat ("\n\n--- Kontroly ---" )
cat("\n Kontrola: Delka vektoru_kolmeho_prumetu_na_jizni_stene: ", velikost(vektor_kolmeho_prumetu_na_jizni_stene), " m. ")
cat("\n Kontrola: delka zkraceneho_vektoru_kolmeho_prumetu_na_jizni_stene: ", velikost(zkraceny_vektor_kolmeho_prumetu_na_jizni_stene), " m. ")
cat("\n Kontrola: Délka jeho kolmého průmětu stylu na stěhu pomoci cosinus: ", velikost(stylus_dolu)*cos(uhel_stylus_stena), " m. ")
cat("\n Kontrola: Výška stojky pomocí sinu: ",sin(uhel_stylus_stena)*velikost(stylus_dolu) , " m. ")

cat ("\n\n--- Úhly hodin neboli ciferník --- " )
cat ("\nÚhel 180° od východu po západ Slunce se rozdělí na 12 dílů, 12 hodin po 15° (360/24)")
cat ("\nVektor severu je normálovým vektorem plochy 6. hodiny ranní, který kolem osy polárky otáčíme po 15°")
cat ("\nHledáme pak průsečík těchto 12 rovin s jižní stěnou (vektorové součiny), které definují vektory či paprsky jednotlivých hodin na slunečních hodinách. Protože stylus prochází stěnou, tak i tyto průsečíky procházejí jedním bodem. Samozřejmě mimo póly, kde je rovnoběžně se stěnou, kolmo na zem. Na rovníku je rovnoběžně se zemí čili kolmo na stěnu.")

cat ("\n\n--- Vektory hodin s rovnikovym cifernikem ---\n")
cat ("\nZákladní představa je Zeměkoule v den rovnodennosti v poledne, kdy na rovníku svítí Slunce v nadhlavníku, tzn. paprsky procházejí předozadní osou kolmo na severo-jižní osu Zeměkoule. Každou hodinu se Zeměkoule pootočí o 15° (=360°/24hodin). To, co vytvoříme jsou de facto rovníkové sluneční hodiny, tzn. ty, ktere maji cifernik kolmy na polus. Na rovníku totiž je stylus, polus i gnomon totožný.")

cat ("\nVytvoříme si tedy tabulku 13x3. To je třináct vektorů po třech souřadnicích (od 6:00 do 18:00). V ose z jsou nuly. V ose x siny úhlů, v ose y kosiny úhlů. Vektor pro 18:00 je samozřejmě nadbytečný (=-vektor(6:00)), ale nevadí.\n")
roviny_hodin<-matrix(1:(3*13), 13,3)# vytvorime si tabulku 13x3 s nejakymi cisly
roviny_hodin[,3]<-0 # v ose z, treti sloupec jsou nuly
roviny_hodin[,1]<-sin(pi/2+pi/12*(0:12)) # osa x jsou siny od 1 do -1 
roviny_hodin[,2]<-cos(pi/2+pi/12*(0:12)) # osa y jsou cosiny od 0 do 1 a pak zas do 0. Pi v radianech znamena 180°.
rownames(roviny_hodin)<- sprintf("%s:00",6:18) # vytvori 6:00", "7:00...
colnames(roviny_hodin)<- c( "X", "Y","Z")

cat ("\nNormálové vektory rovin jednotlivých hodin.\n")
print(round(roviny_hodin, 3))
print_uhel_vektoru(roviny_hodin[3,], roviny_hodin[4,], "osma a devata hodina", "     Kontrola: ")




cat ("\n\n--- Vektory hodiny s vodorovnym cifernikem ---\n")
vektory_hodin_vodorovne <- t(apply(roviny_hodin, 1, function(x) vektorovy_soucin(-x, zenit)))
rownames(vektory_hodin_vodorovne)<-sprintf("%s:00",6:18)
# c( "6:00", "7:00","8:00","9:00","10:00", "11:00","12:00","13:00", "14:00", "15:00" ,"16:00","17:00","18:00")
colnames(vektory_hodin_vodorovne)<- c( "X", "Y","Z")
print(round(vektory_hodin_vodorovne, 3))
# cat ("\nVelikost vodorovnych hodin pro kontrolu\n")
# print(round(apply(vektory_hodin_vodorovne, 1, function(x) velikost(x)), 3))
# stop()

cat ("\n\nVypočteme úhel mezi jednotlivými hodinami na vodorovnem ciferniku\n")
vektory_hodin_vodorovne_s_nasledujici <- cbind(vektory_hodin_vodorovne, rotace_matice_po_radcich(vektory_hodin_vodorovne))
# kontrola: print(vektory_hodin_svisle_s_nasledujici)
# rm(uhly_mezi_vektory_hodin_vodorovne) # asi zbytecne
uhly_mezi_vektory_hodin_vodorovne <- as.matrix(apply(vektory_hodin_vodorovne_s_nasledujici, 1, function(x) 
rad2deg(uhel_vektoru(x[1:3], x[4:6]))))
rownames(uhly_mezi_vektory_hodin_vodorovne) <- sprintf("%s:00-%s:00", c(6:18), c(7:19))
colnames(uhly_mezi_vektory_hodin_vodorovne) <- c("úhly mezi hodinami")

print(matrix(uhly_mezi_vektory_hodin_vodorovne[1:12,], dimnames=list(sprintf("%s:00-%s:00", c(6:17), c(7:18)), c("úhly mezi hodinami")))) # aby to tisklo vertikalne, tak se to musi udelat touto hruzou...

uhly_mezi_vektory_hodin_vodorovne <- rbind(c(0),uhly_mezi_vektory_hodin_vodorovne )
uhly_mezi_vektory_hodin_vodorovne <- cbind(uhly_mezi_vektory_hodin_vodorovne, round(cumsum(uhly_mezi_vektory_hodin_vodorovne[,1])-90,1))
#  print(uhly_mezi_vektory_hodin_vodorovne)
rownames(uhly_mezi_vektory_hodin_vodorovne) <- sprintf("%s:00", c(6:19))
cat("\n")
print(matrix(uhly_mezi_vektory_hodin_vodorovne[1:13, 2], dimnames=list(sprintf("%s:00", c(6:18)), c("úhel od poledne/severu"))))
# print(uhly_mezi_vektory_hodin_vodorovne[1:12])
# kontrola: print(mean(uhly_mezi_vektory_hodin_vodorovne[1:12]))
# stop("debug") # 

cat ("\nVektory jednotlivých hodiny na vodorovném ciferníku otočené do vodorovné polohy\n")
vektory_hodin_vodorovne_otocene_zpet <- t(apply(vektory_hodin_vodorovne, 1, function(x) rotace_vektoru_okolo_osy(x, "y", -(pi/2-deklinace))))
rownames(vektory_hodin_vodorovne_otocene_zpet)<-sprintf("%s:00",6:18)
colnames(vektory_hodin_vodorovne_otocene_zpet)<- c( "X", "Y","Z")
print(round(vektory_hodin_vodorovne_otocene_zpet, 3))


cat ("\n\n--- Vektory hodin na stěně --- \n")
cat ("\nVektory hodin na stěně jsou vektorovým součinem roviny jižní strany s rovinami hodin\n")
vektory_hodin_svisle <- t(apply(roviny_hodin, 1, function(x) vektorovy_soucin(x, normalovy_vektor_jizni_steny))) 
colnames(vektory_hodin_svisle)<- c( "X", "Y","Z")		# popis sloupcu a radek tabulky
rownames(vektory_hodin_svisle)<-sprintf("%s:00",18:6)
cat ("\nVektory jednotlivých hodiny na svislém ciferniku v absolutních souřadnicích:\n")
print(round(vektory_hodin_svisle, 3))
cat("V praxi vcelku neupotřebitelné, protože jsou v absolutních souřadnicích, proto je otočíme, abychom je měli jako by v souřadnicích jižní stěny domu. Jedná se pochopitelně o dvě pootočení: 1) zpět o (90-deklinace) a 2) zpět o úklon baráku k západu \n")

cat ("\n\nVektory jednotlivých hodiny na svislém ciferniku otočené do svislé polohy natočené podle jižní stěny domu. (Y - je zde vodorovná souřadnice, Z je svislá. Kontrola 12:00 je svislý stín i u pootočené jižní strany.)\n")
vektory_hodin_svisle_otocene_zpet_deklinace <- t(apply(vektory_hodin_svisle, 1, function(x) rotace_vektoru_okolo_osy(x, "y", -(pi/2-deklinace))))
vektory_hodin_svisle_otocene_zpet <- t(apply(vektory_hodin_svisle_otocene_zpet_deklinace, 1, function(x) rotace_vektoru_okolo_osy(x, "z", -uklon_jizni_steny)))
# rownames(vektory_hodin_svisle_otocene_zpet)<-sprintf("%s:00",6:18)
rownames(vektory_hodin_svisle_otocene_zpet)<-sprintf("%s:00",18:6)
colnames(vektory_hodin_svisle_otocene_zpet)<- c( "X", "Y","Z")
print(round(vektory_hodin_svisle_otocene_zpet, 3))

# cat ("\nVelikost pro kontrolu (svisly cifernik)\n")
# print(round(apply(vektory_hodin_svisle, 1, function(x) velikost(x)), 3))

cat ("\nVypočteme úhel mezi jednotlivými hodinami na svislem ciferniku\n")
vektory_hodin_svisle_s_nasledujici <- cbind(vektory_hodin_svisle, rotace_matice_po_radcich(vektory_hodin_svisle))
# kontrola: print(vektory_hodin_svisle_s_nasledujici)
# rm(uhly_mezi_vektory_hodin_svisle) # je to treba?
uhly_mezi_vektory_hodin_svisle <- as.matrix(apply(vektory_hodin_svisle_s_nasledujici, 1, function(x) rad2deg(uhel_vektoru(x[1:3], x[4:6]))))
# rownames(uhly_mezi_vektory_hodin_svisle) <- sprintf("%s:00-%s:00", 6:18, c(7:18,6))
rownames(uhly_mezi_vektory_hodin_svisle) <- sprintf("%s:00-%s:00", 18:6, c(6,18:7))
colnames(uhly_mezi_vektory_hodin_svisle) <- c("úhel mezi hodinami na svislém ciferníku")		# popis sloupcu a radek tabulky
print(matrix(uhly_mezi_vektory_hodin_svisle[1:12,], dimnames=list(sprintf("%s:00-%s:00", 17:6, 18:7), c("úhel mezi hodinami na svislém ciferníku")))) # aby to tisklo tabulku vertikalne, tak se to musi udelat touto hruzou...

uhly_mezi_vektory_hodin_svisle <- rbind(c(0),uhly_mezi_vektory_hodin_svisle )
uhly_mezi_vektory_hodin_svisle <- cbind(uhly_mezi_vektory_hodin_svisle, (cumsum(uhly_mezi_vektory_hodin_svisle[,1])-sum(uhly_mezi_vektory_hodin_svisle[1:7,1])))
rownames(uhly_mezi_vektory_hodin_svisle) <- sprintf("%s:00", c(18:5))
colnames(uhly_mezi_vektory_hodin_svisle) <- c("úhel od svislice na svislém ciferníku","coto je") # popis sloupcu a radek tabulky
cat("\n")
print(matrix(uhly_mezi_vektory_hodin_svisle[1:13, 2], dimnames=list(sprintf("%s:00", c(18:6)), c("úhel od poledne/svislice"))))
# print(uhly_mezi_vektory_hodin_svisle[1:12])

cat("\n\n --- Konec výpočtů, následují grafy --- \n")


souradnice_popisku_svisle <- function(slope, popisek, vpravo=TRUE) {
	pozadi_cislic="yellow" # dublovane, pozor
# 	pozadi=cat(rep(times=nchar(popisek),"█"), sep="")
	pozadi=paste(rep("\U2588", nchar(popisek)), collapse="")
	vpravo=vpravo*2-1 # převede TRUE FALSE na +1 -1(vlevo) 
	ypsilon_nahore=1 # pro ctvercovy cifernik
	ypsilon_dole=1 	 # pro ctvercovy cifernik
# 	ypsilon_nahore=.2
# 	ypsilon_dole=1.8
	ypsilon_nahore=.1
	ypsilon_dole=1.9
	pomer_dole=ypsilon_dole/1
	pomer_nahore=ypsilon_nahore/1
	cat("\n popisek: ", popisek, "; slope: ", slope, "; vpravo: ", vpravo, sep="")
	if (slope>0) { # tzn. /
		if (vpravo == 1) { 
			pomer=pomer_nahore
			y=+ypsilon_nahore
		} else {
			pomer=pomer_dole 
			y=-ypsilon_dole 
		}
		if (slope > pomer ) {
			text(y/slope, y, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y, popisek, col="brown") # 	y=ax  "09:00",
		} else {
			x=vpravo; text(x, x*slope, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			x=vpravo; text(x, x*slope, popisek, col="brown") # 	y=ax  "09:00",
		}
	} else { # slope <0 \
		if (vpravo == 1) { 
			pomer=pomer_dole 
			y=-ypsilon_dole 
		} else {
			pomer=pomer_nahore
			y=+ypsilon_nahore
		}
		if (slope < -pomer) {
			text(y/slope, y  , pozadi,  col = pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y  , popisek, col = "brown") # 	y=ax  "09:00",
		} else {
			x=1*vpravo; text(x, x*slope, pozadi,  col = pozadi_cislic ) # 	y=ax  "09:00",
			x=1*vpravo; text(x, x*slope, popisek, col = "brown" ) # 	y=ax  "09:00",
		}
	}
}

# stop() # debug
plot_cifernik_svisly <- function(slope, nazev_souboru="cifernik_odpad.png") { # s priponou
	print(slope)
 	par(pty="s", mar=c(8, .1, .1, .1), xpd=FALSE ) # vynuti ctverec a okraje
#  	dev.new(res=300)
# par(mar=c(5.1, 4.1, 4.1, 8.1), xpd=TRUE (neomezuje graf na ctverec))
# 	plot(0,0, type = "n", asp =1 ,  bty="n", axes=F, ylab="", xlab="", xlim=c(-1, +1), ylim=c(-1.8, +.2))
	plot(0,0, type = "n", asp =1 ,  bty="n", axes=F, ylab="", xlab="", xlim=c(-1, +1), ylim=c(-1.9, +.1))
	abline(h=0, col="yellow", untf = TRUE )
	abline(v=0, col="yellow")
	abline(0,slope[1], col="darkgreen") # sesta hodina je zelena
	abline(0,slope[2])
	abline(0,slope[3])
	abline(0,slope[4])
	abline(0,slope[5])
	abline(0,slope[6])
	# abline(0,slope[7], col="red", coef=.5) # poledne je cervene
	abline(0,slope[7], col="red") # poledne je cervene
	# plot(0,slope[7])
	abline(0,slope[8])
	abline(0,slope[9])
	abline(0,slope[10])
	abline(0,slope[11])
	abline(0,slope[12])
	points(-uchylka_na_stene_x, uchylka_na_stene_y, type="p", pch=4)
	if (1==1) { # toto zapina/vypina popisky
	pozadi_cislic="yellow"
# 	text(+.75, 0, "osa +X", col = "brown")
# 	text(-.75, 0, "osa -X", col = "brown")
# 	text(0,+.5,  "osa +Y", col = "brown")
# 	text(0,-.5,  "osa -Y", col = "brown")
stylus_souradnice=paste( "[", round(-uchylka_na_stene_x, 3) , "; " , round(uchylka_na_stene_y, 3), "; " , round(uchylka_od_steny_z, 3), "]", sep="")
	souradnice_popisku_svisle(slope[8],  "23", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[9],  "22", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[10], "21", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[11], "20", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[12], "19", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[1],  "18", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[2],  "17", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[3],  "16", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[4],  "15", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[5],  "14", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[6],  "13", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[7],  "12", vpravo=TRUE) 
	souradnice_popisku_svisle(slope[8],  "11", vpravo=FALSE) 
	souradnice_popisku_svisle(slope[9],  "10", vpravo=FALSE) 
	souradnice_popisku_svisle(slope[10], "9",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[11], "8",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[12], "7",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[1],  "6",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[2],  "5",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[3],  "4",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[4],  "3",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[5],  "2",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[6],  "1",  vpravo=FALSE) 
	souradnice_popisku_svisle(slope[7],  "0",  vpravo=FALSE) 
 	par(xpd=TRUE ) #umozni kreslit mimo plot

 	text(-1.3,-2.35, adj=0,  paste("Ciferník svislých slunečních hodin",
	"\nDeklinace ", rad2deg(deklinace), "°",
	"\nJižní stěna ukloněná o ",rad2deg(uklon_jizni_steny),"°", 
	"\nPaprsek 12:00 směřuje kolmo k zemi", 
	"\nÚhel průmětu na stěně od svislice: ", round(rad2deg(uklon_prumetu_stylu_od_zenitu),2),"°",
	"\nÚklon stylu ode zdi: ", round(rad2deg(uhel_stylus_stena),2),"°",
	"\nSouřadnice stylu \"×\" na stěně: ",stylus_souradnice,
	sep=""))

	text(1.2,-2.3, adj=1,  paste0("Úhly od 12:00\n",paste0(strwrap(paste(sprintf("%s(%s)",  c(18:6), round( uhly_mezi_vektory_hodin_svisle[1:13, 2],1)), collapse=" "), width=30), collapse="\n")))
	
	}
	dev.copy(png,
			filename=nazev_souboru, width = 15, height = 15, units = 'cm', res=300);# musi tam byt vsechny tyto parametry, ma-li fungovat resolution
	dev.off();
}



souradnice_popisku_vodorovne <- function(slope, popisek, vpravo=TRUE) {
	pozadi_cislic="yellow" # dublovane, pozor
# 	pozadi_cislic="green" # dublovane, pozor
# 	pozadi=cat(rep(times=nchar(popisek),"█"), sep="")
	pozadi=paste(rep("\U2588", nchar(popisek)), collapse="")
	vpravo=vpravo*2-1 # převede TRUE FALSE na +1 -1(vlevo) 
# 	ypsilon_nahore=.2
# 	ypsilon_dole=1.8
# 	ypsilon_nahore=1 # pro ctvercovy cifernik
# 	ypsilon_dole=1 	 # pro ctvercovy cifernik
	ypsilon_nahore=1.9
	ypsilon_dole=.1
	pomer_nahore=ypsilon_nahore/1
	pomer_dole=ypsilon_dole/1
# 	cat("\n debug: popisek: ", popisek, "; slope: ", slope, "; vpravo: ", vpravo, sep="")
	if (slope>0) { # tzn. /
		if (vpravo == 1) { 
			pomer=pomer_nahore
			y=+ypsilon_nahore
		} else {
			pomer=pomer_dole 
			y=-ypsilon_dole 
		}
		if (slope > pomer ) {
			text(y/slope, y, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y, popisek, col="brown") # 	y=ax  "09:00",
		} else {
			x=vpravo; text(x, x*slope, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			x=vpravo; text(x, x*slope, popisek, col="brown") # 	y=ax  "09:00",
		}
	} else { # slope <0 \
		if (vpravo == 1) { 
			pomer=pomer_dole 
			y=-ypsilon_dole 
		} else {
			pomer=pomer_nahore
			y=+ypsilon_nahore
		}
		if (slope < -pomer) {
			text(y/slope, y  , pozadi,  col = pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y  , popisek, col = "brown") # 	y=ax  "09:00",
		} else {
			x=1*vpravo; text(x, x*slope, pozadi,  col = pozadi_cislic ) # 	y=ax  "09:00",
			x=1*vpravo; text(x, x*slope, popisek, col = "brown" ) # 	y=ax  "09:00",
		}
	}
}

plot_cifernik_vodorovny <- function(slope, nazev_souboru="cifernik_odpad.png") { # s priponou
 	cat("\nplot_cifernik_vodorovny. Debug vypis: \n")
 	print(slope)
	par(pty="s") # vynuti ctverec
# 	png("test.png",width=3.25,height=3.25,units="in",res=1200)
# 	png(res=300)
# 	plot.new()
#  	dev.new(width = 15, height = 15, units = 'cm', res=600)
# png(nazev_souboru, width = 15, height = 15, units = 'cm', res = 300)
# 	pdf(file=nazev_souboru, encoding="ISOLatin9.enc" )
# 	pdf(file=nazev_souboru, encoding="CP1250.enc" )
 	par(pty="s", mar=c(8, .1, .1, .1), xpd=FALSE ) # vynuti ctverec
	plot(0,0, type = "n", asp = 1,  bty="n", axes=F, ylab="", xlab="", xlim=c(-1, +1), ylim=c(-.1, +1.9))
	abline(h=0, col="yellow", untf = TRUE )
	abline(v=0, col="yellow")
	abline(0,slope[1], col="green") # sesta hodina je zelena
	abline(0,slope[2])
	abline(0,slope[3])
	abline(0,slope[4])
	abline(0,slope[5])
	abline(0,slope[6])
	# abline(0,slope[7], col="red", coef=.5) # poledne je cervene
	abline(0,slope[7], col="red") # poledne je cervene
	# plot(0,slope[7])
	abline(0,slope[8])
	abline(0,slope[9])
	abline(0,slope[10])
	abline(0,slope[11])
	abline(0,slope[12])
	if (1==1) {
	pozadi_cislic="yellow"
# 	text(+.75, 0, "osa +X", col = "brown")
# 	text(-.75, 0, "osa -X", col = "brown")
# 	text(0,+.5,  "osa +Y", col = "brown")
# 	text(0,-.5,  "osa -Y", col = "brown")

	souradnice_popisku_vodorovne(slope[8],  "23", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[9],  "22", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[10], "21", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[11], "20", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[12], "19", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[1],  "18", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[2],  "17", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[3],  "16", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[4],  "15", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[5],  "14", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[6],  "13", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[7],  "12", vpravo=TRUE) 
	souradnice_popisku_vodorovne(slope[8],  "11", vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[9],  "10", vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[10], "9",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[11], "8",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[12], "7",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[1],  "6",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[2],  "5",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[3],  "4",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[4],  "3",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[5],  "2",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[6],  "1",  vpravo=FALSE) 
	souradnice_popisku_vodorovne(slope[7],  "0",  vpravo=FALSE) 
 	par(xpd=TRUE ) #umozni kreslit mimo plot

	text(-1.3,-.5, adj=0,   paste(
	"Ciferník vodorovných slunečních hodin",
	"\nPaprsek 12:00 směřuje na sever", 
	"\nDeklinace (úhel stylu od podložky): \n	", rad2deg(deklinace), "°",
	sep=""))
	
	text(1.2,-.5, adj=1, paste0("Úhly symetricky od 12:00\n",paste0(strwrap(paste(sprintf("%s:00(%s°)",  c(12:6), round( uhly_mezi_vektory_hodin_vodorovne[7:13, 2],1)), collapse=" "), width=28), collapse="\n")))
	
	}
 	dev.copy(png, filename=nazev_souboru, width = 15, height = 15, units = 'cm', res=300);
# 	dev.copy(pdf, filename=nazev_souboru); # problemy s diakritikou
 	dev.off();
}


souradnice_popisku_vodorovne <- function(slope, popisek, vpravo=TRUE) {
	pozadi_cislic="yellow" # dublovane, pozor
# 	pozadi_cislic="green" # dublovane, pozor
# 	pozadi=cat(rep(times=nchar(popisek),"█"), sep="")
	pozadi=paste(rep("\U2588", nchar(popisek)), collapse="")
	vpravo=vpravo*2-1 # převede TRUE FALSE na +1 -1(vlevo) 
# 	ypsilon_nahore=.2
# 	ypsilon_dole=1.8
# 	ypsilon_nahore=1 # pro ctvercovy cifernik
# 	ypsilon_dole=1 	 # pro ctvercovy cifernik
	ypsilon_nahore=1.9
	ypsilon_dole=.1
	pomer_nahore=ypsilon_nahore/1
	pomer_dole=ypsilon_dole/1
# 	cat("\n debug: popisek: ", popisek, "; slope: ", slope, "; vpravo: ", vpravo, sep="")
	if (slope>0) { # tzn. /
		if (vpravo == 1) { 
			pomer=pomer_nahore
			y=+ypsilon_nahore
		} else {
			pomer=pomer_dole 
			y=-ypsilon_dole 
		}
		if (slope > pomer ) {
			text(y/slope, y, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y, popisek, col="brown") # 	y=ax  "09:00",
		} else {
			x=vpravo; text(x, x*slope, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			x=vpravo; text(x, x*slope, popisek, col="brown") # 	y=ax  "09:00",
		}
	} else { # slope <0 \
		if (vpravo == 1) { 
			pomer=pomer_dole 
			y=-ypsilon_dole 
		} else {
			pomer=pomer_nahore
			y=+ypsilon_nahore
		}
		if (slope < -pomer) {
			text(y/slope, y  , pozadi,  col = pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y  , popisek, col = "brown") # 	y=ax  "09:00",
		} else {
			x=1*vpravo; text(x, x*slope, pozadi,  col = pozadi_cislic ) # 	y=ax  "09:00",
			x=1*vpravo; text(x, x*slope, popisek, col = "brown" ) # 	y=ax  "09:00",
		}
	}
}



souradnice_popisku_rovnikovy_hranaty <- function(slope, popisek, vpravo=TRUE) {
#    print(slope) # debug
	pozadi_cislic="yellow" # dublovane, pozor
# 	pozadi_cislic="green" # dublovane, pozor
# 	pozadi=cat(rep(times=nchar(popisek),"█"), sep="")
	pozadi=paste(rep("\U2588", nchar(popisek)), collapse="")
	vpravo=vpravo*2-1 # převede TRUE FALSE na +1 -1(vlevo) 
# 	ypsilon_nahore=.2
# 	ypsilon_dole=1.8
# 	ypsilon_nahore=1 # pro ctvercovy cifernik
# 	ypsilon_dole=1 	 # pro ctvercovy cifernik
	ypsilon_nahore=1
	ypsilon_dole=1
	pomer_nahore=ypsilon_nahore/1
	pomer_dole=ypsilon_dole/1
# 	cat("\n debug: popisek: ", popisek, "; slope: ", slope, "; vpravo: ", vpravo, sep="")
	if (slope>0) { # tzn. /
		if (vpravo == 1) { 
			pomer=pomer_nahore
			y=+ypsilon_nahore
		} else {
			pomer=pomer_dole 
			y=-ypsilon_dole 
		}
		if (slope > pomer ) {
			text(y/slope, y, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y, popisek, col="brown") # 	y=ax  "09:00",
		} else {
			x=vpravo; text(x, x*slope, pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
			x=vpravo; text(x, x*slope, popisek, col="brown") # 	y=ax  "09:00",
		}
	} else { # slope <0 \
		if (vpravo == 1) { 
			pomer=pomer_dole 
			y=-ypsilon_dole 
		} else {
			pomer=pomer_nahore
			y=+ypsilon_nahore
		}
		if (slope < -pomer) {
			text(y/slope, y  , pozadi,  col = pozadi_cislic) # 	y=ax  "09:00",
			text(y/slope, y  , popisek, col = "brown") # 	y=ax  "09:00",
		} else {
			x=1*vpravo; text(x, x*slope, pozadi,  col = pozadi_cislic ) # 	y=ax  "09:00",
			x=1*vpravo; text(x, x*slope, popisek, col = "brown" ) # 	y=ax  "09:00",
		}
	}
}


souradnice_popisku_rovnikovy_kulaty <- function(slope, popisek, vpravo=TRUE) {
#    print(slope) # debug
	pozadi_cislic="yellow" # dublovane, pozor
	pozadi=paste(rep("\U2588", nchar(popisek)), collapse="")
	vpravo=vpravo*2-1 # převede TRUE FALSE na +1 -1(vlevo) 
	text(vpravo*cos(atan(slope)), vpravo*sin(atan(slope)), pozadi,  col=pozadi_cislic) # 	y=ax  "09:00",
	text(vpravo*cos(atan(slope)), vpravo*sin(atan(slope)), popisek, col="brown") # 	y=ax  "09:00",
}



plot_cifernik_rovnikovy_predni <- function(slope, nazev_souboru="cifernik_odpad.png", kulaty=FALSE, letni=FALSE) { # s priponou
 	cat("\nplot_cifernik_rovnikovy_predni. Debug vypis: \n")
 	print(slope) # debug
# 	par(pty="s") # vynuti ctverec
 	par(pty="s", mar=c(8, .1, .1, .1), xpd=FALSE ) # vynuti ctverec
	plot(0,0, type = "n", asp = 1,  bty="n", axes=F, ylab="", xlab="", xlim=c(-1, +1), ylim=c(-1, +1))
	abline(h=0, col="yellow", untf = TRUE )
	abline(v=0, col="yellow")
	abline(0,slope[1], col="green") # sesta hodina je zelena
	abline(0,slope[2])
	abline(0,slope[3])
	abline(0,slope[4])
	abline(0,slope[5])
	abline(0,slope[6])
	# abline(0,slope[7], col="red", coef=.5) # poledne je cervene
	abline(0,slope[7], col="red") # poledne je cervene
	# plot(0,slope[7])
	abline(0,slope[8])
	abline(0,slope[9])
	abline(0,slope[10])
	abline(0,slope[11])
	abline(0,slope[12])
	if (1==1) {
	pozadi_cislic="yellow"
	if (kulaty==TRUE) {
		if (letni==TRUE){                                   
			souradnice_popisku_rovnikovy_kulaty(slope[8],  "2" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[9],  "3" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[10], "4" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[11], "5" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[12], "6" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[1],  "7" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[2],  "8" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[3],  "9" , vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[4],  "10", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[5],  "11", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[6],  "12", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[7],  "13", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[8],  "14", vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[9],  "15", vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[10], "16",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[11], "17",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[12], "18",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[1],  "19",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[2],  "20",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[3],  "21",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[4],  "22",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[5],  "23",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[6],  "0" ,  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[7],  "1",  vpravo=FALSE) 
	
		}else{
			souradnice_popisku_rovnikovy_kulaty(slope[8],  "1", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[9],  "2", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[10], "3", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[11], "4", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[12], "5", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[1],  "6", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[2],  "7", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[3],  "8", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[4],  "9", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[5],  "10", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[6],  "11", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[7],  "12", vpravo=TRUE) 
			souradnice_popisku_rovnikovy_kulaty(slope[8],  "13", vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[9],  "14", vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[10], "15",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[11], "16",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[12], "17",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[1],  "18",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[2],  "19",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[3],  "20",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[4],  "21",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[5],  "22",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[6],  "23",  vpravo=FALSE) 
			souradnice_popisku_rovnikovy_kulaty(slope[7],  "0",  vpravo=FALSE) 
		}
	} else {
		souradnice_popisku_rovnikovy_hranaty(slope[8],  "1", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[9],  "2", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[10], "3", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[11], "4", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[12], "5", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[1],  "6", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[2],  "7", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[3],  "8", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[4],  "9", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[5],  "10", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[6],  "11", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[7],  "12", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[8],  "13", vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[9],  "14", vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[10], "15",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[11], "16",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[12], "17",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[1],  "18",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[2],  "19",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[3],  "20",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[4],  "21",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[5],  "22",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[6],  "23",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[7],  "0",  vpravo=FALSE) 
	}
	
 	par(xpd=TRUE ) #umozni kreslit mimo plot

	text(-1.3,-1.5, adj=0,   paste(
	"Přední ciferník rovníkových slunečních hodin",
	"\nPaprsek 12:00 směřuje kolmo k zemi", 
	"\nDeklinace (úhel stylu od podložky): \n	", rad2deg(deklinace), "°",
	sep=""))
	
	text(1.2,-1.5, adj=1, "Úhly symetricky od 12:00 po 15°\n")
	
	}
 	dev.copy(png, filename=nazev_souboru, width = 15, height = 15, units = 'cm', res=300);
# 	dev.copy(pdf, filename=nazev_souboru); # problemy s diakritikou
 	dev.off();
}

plot_cifernik_rovnikovy_zadni <- function(slope, nazev_souboru="cifernik_odpad.png", kulaty=FALSE) { # s priponou
 	cat("\nplot_cifernik_rovnikovy_zadni. Debug vypis: \n")
 	print(slope) # debug
# 	par(pty="s") # vynuti ctverec
 	par(pty="s", mar=c(8, .1, .1, .1), xpd=FALSE ) # vynuti ctverec
	plot(0,0, type = "n", asp = 1,  bty="n", axes=F, ylab="", xlab="", xlim=c(-1, +1), ylim=c(-1, +1))
	abline(h=0, col="yellow", untf = TRUE )
	abline(v=0, col="yellow")
	abline(0,slope[1], col="green") # sesta hodina je zelena
	abline(0,slope[2])
	abline(0,slope[3])
	abline(0,slope[4])
	abline(0,slope[5])
	abline(0,slope[6])
	# abline(0,slope[7], col="red", coef=.5) # poledne je cervene
	abline(0,slope[7], col="red") # poledne je cervene
	# plot(0,slope[7])
	abline(0,slope[8])
	abline(0,slope[9])
	abline(0,slope[10])
	abline(0,slope[11])
	abline(0,slope[12])
	if (1==1) {
	pozadi_cislic="yellow"
# 	text(+.75, 0, "osa +X", col = "brown")
# 	text(-.75, 0, "osa -X", col = "brown")
# 	text(0,+.5,  "osa +Y", col = "brown")
# 	text(0,-.5,  "osa -Y", col = "brown")

	if (kulaty==TRUE) {
		souradnice_popisku_rovnikovy_kulaty(slope[8],  "23", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[9],  "22", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[10], "21", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[11], "20", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[12], "19", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[1],  "18", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[2],  "17", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[3],  "16", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[4],  "15", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[5],  "14", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[6],  "13", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[7],  "12", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_kulaty(slope[8],  "11", vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[9],  "10", vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[10], "9",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[11], "8",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[12], "7",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[1],  "6",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[2],  "5",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[3],  "4",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[4],  "3",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[5],  "2",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[6],  "1",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_kulaty(slope[7],  "0",  vpravo=FALSE) 
	} else {
		souradnice_popisku_rovnikovy_hranaty(slope[8],  "23", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[9],  "22", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[10], "21", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[11], "20", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[12], "19", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[1],  "18", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[2],  "17", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[3],  "16", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[4],  "15", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[5],  "14", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[6],  "13", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[7],  "12", vpravo=TRUE) 
		souradnice_popisku_rovnikovy_hranaty(slope[8],  "11", vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[9],  "10", vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[10], "9",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[11], "8",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[12], "7",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[1],  "6",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[2],  "5",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[3],  "4",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[4],  "3",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[6],  "1",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[7],  "0",  vpravo=FALSE) 
		souradnice_popisku_rovnikovy_hranaty(slope[5],  "2",  vpravo=FALSE) 
	}
	par(xpd=TRUE ) #umozni kreslit mimo plot

	text(-1.3,-1.5, adj=0,   paste(
	"Zadní ciferník rovníkových slunečních hodin",
	"\nPaprsek 12:00 směřuje kolmo k zemi", 
	"\nDeklinace (úhel stylu od podložky): \n	", rad2deg(deklinace), "°",
	sep=""))
	
	text(1.2,-1.5, adj=1, "Úhly symetricky od 12:00 po 15°\n")
	
	}
 	dev.copy(png, filename=nazev_souboru, width = 15, height = 15, units = 'cm', res=300);
# 	dev.copy(pdf, filename=nazev_souboru); # problemy s diakritikou
 	dev.off();
}

if (2==1) {
# plot.new()
# y=(-a/b)*x - c/b; kde ax+by+c=0
# jeden bod vektoru je [0;0], druhy je konec vektoru
slope=(vektory_hodin_vodorovne_otocene_zpet[,1]/vektory_hodin_vodorovne_otocene_zpet[,2]) # slope=X/Y
plot_cifernik_vodorovny(slope, paste("cifernik_hodin_vodorovny_",sprintf("%02d", round(rad2deg(deklinace),0)),".png"))

slope=-vektory_hodin_svisle_otocene_zpet[,3]/vektory_hodin_svisle_otocene_zpet[,2]
dev.new() # vytvori nove okno pro graf
plot_cifernik_svisly(slope, paste("cifernik_hodin_svisly_",sprintf("%02d", round(rad2deg(deklinace),0)),"_",sprintf("%05g", round(rad2deg(uklon_jizni_steny),2),".png")))

}
dev.new() # vytvori nove okno pro graf
slope=roviny_hodin[,2]/roviny_hodin[,1]
plot_cifernik_rovnikovy_predni(slope, "cifernik_hodin_rovnikovy_predni.png")
dev.new() # vytvori nove okno pro graf
slope=(roviny_hodin[,2]/roviny_hodin[,1])
plot_cifernik_rovnikovy_zadni(slope, "cifernik_hodin_rovnikovy_zadni.png")

dev.new() # vytvori nove okno pro graf
slope=roviny_hodin[,2]/roviny_hodin[,1]
plot_cifernik_rovnikovy_predni(slope, "cifernik_hodin_rovnikovy_kulaty_predni.png", kulaty=TRUE)
dev.new() # vytvori nove okno pro graf
slope=roviny_hodin[,2]/roviny_hodin[,1]
plot_cifernik_rovnikovy_predni(slope, "cifernik_hodin_rovnikovy_kulaty_predni_letni.png", kulaty=TRUE, letni=TRUE)
dev.new() # vytvori nove okno pro graf
slope=(roviny_hodin[,2]/roviny_hodin[,1])
plot_cifernik_rovnikovy_zadni(slope, "cifernik_hodin_rovnikovy_kulaty_zadni.png", kulaty=TRUE)
# plot_cifernik_rovnikovy_zadni(slope, "cifernik_hodin_rovnikovy_predni.png")





cat ("\n\n--- Dražická krokve a stylus mezi nimi --- ")

cat ("\nPrůběžný vektor krokve")

cat ("\nKrokev má sklon střechy a to je 40° vůči vodorovné ploše, tedy vůči jižní hraně baráku. ")
vektor_krokve_na_polu_neotoceno <- rotace_vektoru_okolo_osy(vychod, "x", deg2rad(40))
vektor_krokve_na_polu_otoceno <- rotace_vektoru_okolo_osy(vektor_krokve_na_polu_neotoceno, "z", uklon_jizni_steny) 
vektor_krokve_v_cechach <- rotace_vektoru_okolo_osy(vektor_krokve_na_polu_otoceno, "y", (pi/2-deklinace)) # 90- deklinace 
print_uhel_vektoru(vektor_krokve_v_cechach, vektor_jizni_hrany, "krokve versus jizni hrana", "\n  Kontrola: ") # kontrola 
print_uhel_vektoru(vektor_krokve_v_cechach, normalovy_vektor_jizni_steny, "krokve versus vektor hrebecacu (normalovy vektor jizni steny)", "\n  Kontrola: ") # kontrola 


print_uhel_vektoru(vektor_krokve_v_cechach, stylus_nahoru, "krokve versus stylus dolu", "\n\n  Uhel_1: ") # 
print_uhel_vektoru(normalovy_vektor_jizni_steny, stylus_dolu, "vektor hrebenacu versus stylus dolu", "\n  Uhel_2: ") # 
print_uhel_vektoru(vektor_kolmeho_prumetu_na_jizni_stene, -zenit, "prumetu stylu na stene versus svislice (zenit)", "\n  Uhel_3: ") # 
cat ("\n\nO Uhel_2 se ohne stylus, ktery se přišroubuje do krokví a pak se pootočí do strany tak, aby s krokví svíral Uhel_1. Pro kontrolu by měl kolmý průmět stylu na rovinu krokví svírat Uhel_3 - o to je ukloněn stylus do strany.")

cat ("\n\nSprávně nastavené sluneční hodiny by měly v pravé poledne (13:00 LČ) na svislé stěně domu tvořit svislou čáru a na vodorovné podlaze vykreslit stín ukazující na sever (na půlnoční stranu), tzn. čáru která je o úklon domu pootočená od předozadní osy domu. No to jsem zvědav, zda to bude fungovat... :-) \n")
cat ("\n")
cat ("\n")

cat("\n\n\n"); stop("Konec skriptu...")
